#ifndef POTHOLE_DETECTOR_H
#define POTHOLE_DETECTOR_H

//--------------------------------------------------------------------------------

#include <AssetTracker.h>
#include "PotholeLocation.h"
#include <queue>

using namespace std;

//--------------------------------------------------------------------------------

class PotholeDetector {
    enum State { S_Wait, S_ReadSensor, S_Average, S_Detected };
    
private:
    State state;
    int tick;
    int samples;
    float average;
    int total;
    queue<PotholeLocation>& potholeLocations;
    AssetTracker& accelGpsSensor;
    
public: 
    PotholeDetector(queue<PotholeLocation>& theLocations, AssetTracker& theTracker);
    void execute();
};
    
//--------------------------------------------------------------------------------

#endif